package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Expression
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Transform(
    expression: Expression,
    variables: Iterable[zio.aws.iotsitewise.model.ExpressionVariable],
    processingConfig: Option[
      zio.aws.iotsitewise.model.TransformProcessingConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Transform = {
    import Transform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Transform
      .builder()
      .expression(Expression.unwrap(expression): java.lang.String)
      .variables(variables.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(processingConfig.map(value => value.buildAwsValue()))(
        _.processingConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Transform.ReadOnly =
    zio.aws.iotsitewise.model.Transform.wrap(buildAwsValue())
}
object Transform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Transform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Transform =
      zio.aws.iotsitewise.model.Transform(
        expression,
        variables.map { item =>
          item.asEditable
        },
        processingConfig.map(value => value.asEditable)
      )
    def expression: Expression
    def variables: List[zio.aws.iotsitewise.model.ExpressionVariable.ReadOnly]
    def processingConfig
        : Option[zio.aws.iotsitewise.model.TransformProcessingConfig.ReadOnly]
    def getExpression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expression)
    def getVariables: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.ExpressionVariable.ReadOnly
    ]] = ZIO.succeed(variables)
    def getProcessingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.TransformProcessingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("processingConfig", processingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Transform
  ) extends zio.aws.iotsitewise.model.Transform.ReadOnly {
    override val expression: Expression =
      zio.aws.iotsitewise.model.primitives.Expression(impl.expression())
    override val variables
        : List[zio.aws.iotsitewise.model.ExpressionVariable.ReadOnly] = impl
      .variables()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.ExpressionVariable.wrap(item)
      }
      .toList
    override val processingConfig
        : Option[zio.aws.iotsitewise.model.TransformProcessingConfig.ReadOnly] =
      scala
        .Option(impl.processingConfig())
        .map(value =>
          zio.aws.iotsitewise.model.TransformProcessingConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Transform
  ): zio.aws.iotsitewise.model.Transform.ReadOnly = new Wrapper(impl)
}
