package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PropertyType(
    attribute: Option[zio.aws.iotsitewise.model.Attribute] = None,
    measurement: Option[zio.aws.iotsitewise.model.Measurement] = None,
    transform: Option[zio.aws.iotsitewise.model.Transform] = None,
    metric: Option[zio.aws.iotsitewise.model.Metric] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PropertyType = {
    import PropertyType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PropertyType
      .builder()
      .optionallyWith(attribute.map(value => value.buildAwsValue()))(
        _.attribute
      )
      .optionallyWith(measurement.map(value => value.buildAwsValue()))(
        _.measurement
      )
      .optionallyWith(transform.map(value => value.buildAwsValue()))(
        _.transform
      )
      .optionallyWith(metric.map(value => value.buildAwsValue()))(_.metric)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.PropertyType.ReadOnly =
    zio.aws.iotsitewise.model.PropertyType.wrap(buildAwsValue())
}
object PropertyType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PropertyType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.PropertyType =
      zio.aws.iotsitewise.model.PropertyType(
        attribute.map(value => value.asEditable),
        measurement.map(value => value.asEditable),
        transform.map(value => value.asEditable),
        metric.map(value => value.asEditable)
      )
    def attribute: Option[zio.aws.iotsitewise.model.Attribute.ReadOnly]
    def measurement: Option[zio.aws.iotsitewise.model.Measurement.ReadOnly]
    def transform: Option[zio.aws.iotsitewise.model.Transform.ReadOnly]
    def metric: Option[zio.aws.iotsitewise.model.Metric.ReadOnly]
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Attribute.ReadOnly] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getMeasurement
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Measurement.ReadOnly] =
      AwsError.unwrapOptionField("measurement", measurement)
    def getTransform
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Transform.ReadOnly] =
      AwsError.unwrapOptionField("transform", transform)
    def getMetric
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Metric.ReadOnly] =
      AwsError.unwrapOptionField("metric", metric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PropertyType
  ) extends zio.aws.iotsitewise.model.PropertyType.ReadOnly {
    override val attribute
        : Option[zio.aws.iotsitewise.model.Attribute.ReadOnly] = scala
      .Option(impl.attribute())
      .map(value => zio.aws.iotsitewise.model.Attribute.wrap(value))
    override val measurement
        : Option[zio.aws.iotsitewise.model.Measurement.ReadOnly] = scala
      .Option(impl.measurement())
      .map(value => zio.aws.iotsitewise.model.Measurement.wrap(value))
    override val transform
        : Option[zio.aws.iotsitewise.model.Transform.ReadOnly] = scala
      .Option(impl.transform())
      .map(value => zio.aws.iotsitewise.model.Transform.wrap(value))
    override val metric: Option[zio.aws.iotsitewise.model.Metric.ReadOnly] =
      scala
        .Option(impl.metric())
        .map(value => zio.aws.iotsitewise.model.Metric.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PropertyType
  ): zio.aws.iotsitewise.model.PropertyType.ReadOnly = new Wrapper(impl)
}
