package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  Url,
  Timestamp,
  Description,
  Name,
  ARN,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PortalSummary(
    id: ID,
    name: Name,
    description: Option[Description] = None,
    startUrl: Url,
    creationDate: Option[Timestamp] = None,
    lastUpdateDate: Option[Timestamp] = None,
    roleArn: Option[ARN] = None,
    status: zio.aws.iotsitewise.model.PortalStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PortalSummary = {
    import PortalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PortalSummary
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .startUrl(Url.unwrap(startUrl): java.lang.String)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastUpdateDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateDate)
      .optionallyWith(
        roleArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.roleArn)
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.PortalSummary.ReadOnly =
    zio.aws.iotsitewise.model.PortalSummary.wrap(buildAwsValue())
}
object PortalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PortalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.PortalSummary =
      zio.aws.iotsitewise.model.PortalSummary(
        id,
        name,
        description.map(value => value),
        startUrl,
        creationDate.map(value => value),
        lastUpdateDate.map(value => value),
        roleArn.map(value => value),
        status.asEditable
      )
    def id: ID
    def name: Name
    def description: Option[Description]
    def startUrl: Url
    def creationDate: Option[Timestamp]
    def lastUpdateDate: Option[Timestamp]
    def roleArn: Option[ARN]
    def status: zio.aws.iotsitewise.model.PortalStatus.ReadOnly
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStartUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(startUrl)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDate)
    def getRoleArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PortalStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PortalSummary
  ) extends zio.aws.iotsitewise.model.PortalSummary.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val startUrl: Url =
      zio.aws.iotsitewise.model.primitives.Url(impl.startUrl())
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
    override val lastUpdateDate: Option[Timestamp] = scala
      .Option(impl.lastUpdateDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
    override val roleArn: Option[ARN] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iotsitewise.model.primitives.ARN(value))
    override val status: zio.aws.iotsitewise.model.PortalStatus.ReadOnly =
      zio.aws.iotsitewise.model.PortalStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PortalSummary
  ): zio.aws.iotsitewise.model.PortalSummary.ReadOnly = new Wrapper(impl)
}
