package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  PropertyAlias,
  ID,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTimeSeriesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    assetId: Option[ID] = None,
    aliasPrefix: Option[PropertyAlias] = None,
    timeSeriesType: Option[zio.aws.iotsitewise.model.ListTimeSeriesType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest = {
    import ListTimeSeriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        aliasPrefix.map(value => PropertyAlias.unwrap(value): java.lang.String)
      )(_.aliasPrefix)
      .optionallyWith(timeSeriesType.map(value => value.unwrap))(
        _.timeSeriesType
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListTimeSeriesRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListTimeSeriesRequest.wrap(buildAwsValue())
}
object ListTimeSeriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListTimeSeriesRequest =
      zio.aws.iotsitewise.model.ListTimeSeriesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        assetId.map(value => value),
        aliasPrefix.map(value => value),
        timeSeriesType.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def assetId: Option[ID]
    def aliasPrefix: Option[PropertyAlias]
    def timeSeriesType: Option[zio.aws.iotsitewise.model.ListTimeSeriesType]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getAliasPrefix: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("aliasPrefix", aliasPrefix)
    def getTimeSeriesType
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ListTimeSeriesType] =
      AwsError.unwrapOptionField("timeSeriesType", timeSeriesType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest
  ) extends zio.aws.iotsitewise.model.ListTimeSeriesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
    override val assetId: Option[ID] = scala
      .Option(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val aliasPrefix: Option[PropertyAlias] = scala
      .Option(impl.aliasPrefix())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val timeSeriesType
        : Option[zio.aws.iotsitewise.model.ListTimeSeriesType] = scala
      .Option(impl.timeSeriesType())
      .map(value => zio.aws.iotsitewise.model.ListTimeSeriesType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest
  ): zio.aws.iotsitewise.model.ListTimeSeriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
