package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  NextToken,
  AssetPropertyAlias,
  OffsetInNanos,
  IntervalInSeconds,
  TimeInSeconds,
  InterpolationType,
  MaxInterpolatedResults,
  IntervalWindowInSeconds,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInterpolatedAssetPropertyValuesRequest(
    assetId: Option[ID] = None,
    propertyId: Option[ID] = None,
    propertyAlias: Option[AssetPropertyAlias] = None,
    startTimeInSeconds: TimeInSeconds,
    startTimeOffsetInNanos: Option[OffsetInNanos] = None,
    endTimeInSeconds: TimeInSeconds,
    endTimeOffsetInNanos: Option[OffsetInNanos] = None,
    quality: zio.aws.iotsitewise.model.Quality,
    intervalInSeconds: IntervalInSeconds,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxInterpolatedResults] = None,
    `type`: InterpolationType,
    intervalWindowInSeconds: Option[IntervalWindowInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest = {
    import GetInterpolatedAssetPropertyValuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
      .builder()
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        propertyAlias.map(value =>
          AssetPropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .startTimeInSeconds(
        TimeInSeconds.unwrap(startTimeInSeconds): java.lang.Long
      )
      .optionallyWith(
        startTimeOffsetInNanos.map(value =>
          OffsetInNanos.unwrap(value): Integer
        )
      )(_.startTimeOffsetInNanos)
      .endTimeInSeconds(TimeInSeconds.unwrap(endTimeInSeconds): java.lang.Long)
      .optionallyWith(
        endTimeOffsetInNanos.map(value => OffsetInNanos.unwrap(value): Integer)
      )(_.endTimeOffsetInNanos)
      .quality(quality.unwrap)
      .intervalInSeconds(
        IntervalInSeconds.unwrap(intervalInSeconds): java.lang.Long
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxInterpolatedResults.unwrap(value): Integer)
      )(_.maxResults)
      .`type`(InterpolationType.unwrap(`type`): java.lang.String)
      .optionallyWith(
        intervalWindowInSeconds.map(value =>
          IntervalWindowInSeconds.unwrap(value): java.lang.Long
        )
      )(_.intervalWindowInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest.ReadOnly =
    zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
      .wrap(buildAwsValue())
}
object GetInterpolatedAssetPropertyValuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest =
      zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest(
        assetId.map(value => value),
        propertyId.map(value => value),
        propertyAlias.map(value => value),
        startTimeInSeconds,
        startTimeOffsetInNanos.map(value => value),
        endTimeInSeconds,
        endTimeOffsetInNanos.map(value => value),
        quality,
        intervalInSeconds,
        nextToken.map(value => value),
        maxResults.map(value => value),
        `type`,
        intervalWindowInSeconds.map(value => value)
      )
    def assetId: Option[ID]
    def propertyId: Option[ID]
    def propertyAlias: Option[AssetPropertyAlias]
    def startTimeInSeconds: TimeInSeconds
    def startTimeOffsetInNanos: Option[OffsetInNanos]
    def endTimeInSeconds: TimeInSeconds
    def endTimeOffsetInNanos: Option[OffsetInNanos]
    def quality: zio.aws.iotsitewise.model.Quality
    def intervalInSeconds: IntervalInSeconds
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxInterpolatedResults]
    def `type`: InterpolationType
    def intervalWindowInSeconds: Option[IntervalWindowInSeconds]
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, AssetPropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getStartTimeInSeconds: ZIO[Any, Nothing, TimeInSeconds] =
      ZIO.succeed(startTimeInSeconds)
    def getStartTimeOffsetInNanos: ZIO[Any, AwsError, OffsetInNanos] = AwsError
      .unwrapOptionField("startTimeOffsetInNanos", startTimeOffsetInNanos)
    def getEndTimeInSeconds: ZIO[Any, Nothing, TimeInSeconds] =
      ZIO.succeed(endTimeInSeconds)
    def getEndTimeOffsetInNanos: ZIO[Any, AwsError, OffsetInNanos] =
      AwsError.unwrapOptionField("endTimeOffsetInNanos", endTimeOffsetInNanos)
    def getQuality: ZIO[Any, Nothing, zio.aws.iotsitewise.model.Quality] =
      ZIO.succeed(quality)
    def getIntervalInSeconds: ZIO[Any, Nothing, IntervalInSeconds] =
      ZIO.succeed(intervalInSeconds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxInterpolatedResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getType: ZIO[Any, Nothing, InterpolationType] = ZIO.succeed(`type`)
    def getIntervalWindowInSeconds
        : ZIO[Any, AwsError, IntervalWindowInSeconds] = AwsError
      .unwrapOptionField("intervalWindowInSeconds", intervalWindowInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
  ) extends zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest.ReadOnly {
    override val assetId: Option[ID] = scala
      .Option(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Option[ID] = scala
      .Option(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyAlias: Option[AssetPropertyAlias] = scala
      .Option(impl.propertyAlias())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.AssetPropertyAlias(value)
      )
    override val startTimeInSeconds: TimeInSeconds =
      zio.aws.iotsitewise.model.primitives
        .TimeInSeconds(impl.startTimeInSeconds())
    override val startTimeOffsetInNanos: Option[OffsetInNanos] = scala
      .Option(impl.startTimeOffsetInNanos())
      .map(value => zio.aws.iotsitewise.model.primitives.OffsetInNanos(value))
    override val endTimeInSeconds: TimeInSeconds =
      zio.aws.iotsitewise.model.primitives
        .TimeInSeconds(impl.endTimeInSeconds())
    override val endTimeOffsetInNanos: Option[OffsetInNanos] = scala
      .Option(impl.endTimeOffsetInNanos())
      .map(value => zio.aws.iotsitewise.model.primitives.OffsetInNanos(value))
    override val quality: zio.aws.iotsitewise.model.Quality =
      zio.aws.iotsitewise.model.Quality.wrap(impl.quality())
    override val intervalInSeconds: IntervalInSeconds =
      zio.aws.iotsitewise.model.primitives
        .IntervalInSeconds(impl.intervalInSeconds())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxInterpolatedResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.MaxInterpolatedResults(value)
      )
    override val `type`: InterpolationType =
      zio.aws.iotsitewise.model.primitives.InterpolationType(impl.`type`())
    override val intervalWindowInSeconds: Option[IntervalWindowInSeconds] =
      scala
        .Option(impl.intervalWindowInSeconds())
        .map(value =>
          zio.aws.iotsitewise.model.primitives.IntervalWindowInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest
  ): zio.aws.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest.ReadOnly =
    new Wrapper(impl)
}
