package zio.aws.iotsitewise.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  NextToken,
  AssetPropertyAlias,
  Timestamp,
  MaxResults,
  ID
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetAssetPropertyValueHistoryRequest(
    assetId: Option[ID] = None,
    propertyId: Option[ID] = None,
    propertyAlias: Option[AssetPropertyAlias] = None,
    startDate: Option[Timestamp] = None,
    endDate: Option[Timestamp] = None,
    qualities: Option[Iterable[zio.aws.iotsitewise.model.Quality]] = None,
    timeOrdering: Option[zio.aws.iotsitewise.model.TimeOrdering] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest = {
    import GetAssetPropertyValueHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest
      .builder()
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        propertyAlias.map(value =>
          AssetPropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .optionallyWith(startDate.map(value => Timestamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => Timestamp.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(
        qualities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.qualitiesWithStrings)
      .optionallyWith(timeOrdering.map(value => value.unwrap))(_.timeOrdering)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest.ReadOnly =
    zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest
      .wrap(buildAwsValue())
}
object GetAssetPropertyValueHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest =
      zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest(
        assetId.map(value => value),
        propertyId.map(value => value),
        propertyAlias.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        qualities.map(value => value),
        timeOrdering.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assetId: Option[ID]
    def propertyId: Option[ID]
    def propertyAlias: Option[AssetPropertyAlias]
    def startDate: Option[Timestamp]
    def endDate: Option[Timestamp]
    def qualities: Option[List[zio.aws.iotsitewise.model.Quality]]
    def timeOrdering: Option[zio.aws.iotsitewise.model.TimeOrdering]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, AssetPropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getQualities
        : ZIO[Any, AwsError, List[zio.aws.iotsitewise.model.Quality]] =
      AwsError.unwrapOptionField("qualities", qualities)
    def getTimeOrdering
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.TimeOrdering] =
      AwsError.unwrapOptionField("timeOrdering", timeOrdering)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ) extends zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest.ReadOnly {
    override val assetId: Option[ID] = scala
      .Option(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Option[ID] = scala
      .Option(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyAlias: Option[AssetPropertyAlias] = scala
      .Option(impl.propertyAlias())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.AssetPropertyAlias(value)
      )
    override val startDate: Option[Timestamp] = scala
      .Option(impl.startDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
    override val endDate: Option[Timestamp] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
    override val qualities: Option[List[zio.aws.iotsitewise.model.Quality]] =
      scala
        .Option(impl.qualities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.Quality.wrap(item)
          }.toList
        )
    override val timeOrdering: Option[zio.aws.iotsitewise.model.TimeOrdering] =
      scala
        .Option(impl.timeOrdering())
        .map(value => zio.aws.iotsitewise.model.TimeOrdering.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryRequest
  ): zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
