package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeStorageConfigurationResponse(
    storageType: zio.aws.iotsitewise.model.StorageType,
    multiLayerStorage: Option[zio.aws.iotsitewise.model.MultiLayerStorage] =
      None,
    disassociatedDataStorage: Option[
      zio.aws.iotsitewise.model.DisassociatedDataStorageState
    ] = None,
    retentionPeriod: Option[zio.aws.iotsitewise.model.RetentionPeriod] = None,
    configurationStatus: zio.aws.iotsitewise.model.ConfigurationStatus,
    lastUpdateDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse = {
    import DescribeStorageConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse
      .builder()
      .storageType(storageType.unwrap)
      .optionallyWith(multiLayerStorage.map(value => value.buildAwsValue()))(
        _.multiLayerStorage
      )
      .optionallyWith(disassociatedDataStorage.map(value => value.unwrap))(
        _.disassociatedDataStorage
      )
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .configurationStatus(configurationStatus.buildAwsValue())
      .optionallyWith(
        lastUpdateDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateDate)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeStorageConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse =
      zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse(
        storageType,
        multiLayerStorage.map(value => value.asEditable),
        disassociatedDataStorage.map(value => value),
        retentionPeriod.map(value => value.asEditable),
        configurationStatus.asEditable,
        lastUpdateDate.map(value => value)
      )
    def storageType: zio.aws.iotsitewise.model.StorageType
    def multiLayerStorage
        : Option[zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly]
    def disassociatedDataStorage
        : Option[zio.aws.iotsitewise.model.DisassociatedDataStorageState]
    def retentionPeriod
        : Option[zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly]
    def configurationStatus
        : zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly
    def lastUpdateDate: Option[Timestamp]
    def getStorageType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.StorageType] =
      ZIO.succeed(storageType)
    def getMultiLayerStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly
    ] = AwsError.unwrapOptionField("multiLayerStorage", multiLayerStorage)
    def getDisassociatedDataStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.DisassociatedDataStorageState
    ] = AwsError.unwrapOptionField(
      "disassociatedDataStorage",
      disassociatedDataStorage
    )
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getConfigurationStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly
    ] = ZIO.succeed(configurationStatus)
    def getLastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse
  ) extends zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly {
    override val storageType: zio.aws.iotsitewise.model.StorageType =
      zio.aws.iotsitewise.model.StorageType.wrap(impl.storageType())
    override val multiLayerStorage
        : Option[zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly] = scala
      .Option(impl.multiLayerStorage())
      .map(value => zio.aws.iotsitewise.model.MultiLayerStorage.wrap(value))
    override val disassociatedDataStorage
        : Option[zio.aws.iotsitewise.model.DisassociatedDataStorageState] =
      scala
        .Option(impl.disassociatedDataStorage())
        .map(value =>
          zio.aws.iotsitewise.model.DisassociatedDataStorageState.wrap(value)
        )
    override val retentionPeriod
        : Option[zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly] = scala
      .Option(impl.retentionPeriod())
      .map(value => zio.aws.iotsitewise.model.RetentionPeriod.wrap(value))
    override val configurationStatus
        : zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly =
      zio.aws.iotsitewise.model.ConfigurationStatus
        .wrap(impl.configurationStatus())
    override val lastUpdateDate: Option[Timestamp] = scala
      .Option(impl.lastUpdateDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeStorageConfigurationResponse
  ): zio.aws.iotsitewise.model.DescribeStorageConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
