package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{CapabilityNamespace, ID}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeGatewayCapabilityConfigurationRequest(
    gatewayId: ID,
    capabilityNamespace: CapabilityNamespace
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest = {
    import DescribeGatewayCapabilityConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest
      .builder()
      .gatewayId(ID.unwrap(gatewayId): java.lang.String)
      .capabilityNamespace(
        CapabilityNamespace.unwrap(capabilityNamespace): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeGatewayCapabilityConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest =
      zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest(
        gatewayId,
        capabilityNamespace
      )
    def gatewayId: ID
    def capabilityNamespace: CapabilityNamespace
    def getGatewayId: ZIO[Any, Nothing, ID] = ZIO.succeed(gatewayId)
    def getCapabilityNamespace: ZIO[Any, Nothing, CapabilityNamespace] =
      ZIO.succeed(capabilityNamespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest
  ) extends zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest.ReadOnly {
    override val gatewayId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.gatewayId())
    override val capabilityNamespace: CapabilityNamespace =
      zio.aws.iotsitewise.model.primitives
        .CapabilityNamespace(impl.capabilityNamespace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest
  ): zio.aws.iotsitewise.model.DescribeGatewayCapabilityConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
