package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAccessPolicyRequest(accessPolicyId: ID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest = {
    import DescribeAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest
      .builder()
      .accessPolicyId(ID.unwrap(accessPolicyId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.DescribeAccessPolicyRequest.ReadOnly =
    zio.aws.iotsitewise.model.DescribeAccessPolicyRequest.wrap(buildAwsValue())
}
object DescribeAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribeAccessPolicyRequest =
      zio.aws.iotsitewise.model.DescribeAccessPolicyRequest(accessPolicyId)
    def accessPolicyId: ID
    def getAccessPolicyId: ZIO[Any, Nothing, ID] = ZIO.succeed(accessPolicyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest
  ) extends zio.aws.iotsitewise.model.DescribeAccessPolicyRequest.ReadOnly {
    override val accessPolicyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.accessPolicyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribeAccessPolicyRequest
  ): zio.aws.iotsitewise.model.DescribeAccessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
