package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePortalResponse(
    portalStatus: zio.aws.iotsitewise.model.PortalStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DeletePortalResponse = {
    import DeletePortalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DeletePortalResponse
      .builder()
      .portalStatus(portalStatus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DeletePortalResponse.ReadOnly =
    zio.aws.iotsitewise.model.DeletePortalResponse.wrap(buildAwsValue())
}
object DeletePortalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DeletePortalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DeletePortalResponse =
      zio.aws.iotsitewise.model.DeletePortalResponse(portalStatus.asEditable)
    def portalStatus: zio.aws.iotsitewise.model.PortalStatus.ReadOnly
    def getPortalStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PortalStatus.ReadOnly] =
      ZIO.succeed(portalStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeletePortalResponse
  ) extends zio.aws.iotsitewise.model.DeletePortalResponse.ReadOnly {
    override val portalStatus: zio.aws.iotsitewise.model.PortalStatus.ReadOnly =
      zio.aws.iotsitewise.model.PortalStatus.wrap(impl.portalStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeletePortalResponse
  ): zio.aws.iotsitewise.model.DeletePortalResponse.ReadOnly = new Wrapper(impl)
}
