package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  PropertyValueBooleanValue,
  PropertyValueDoubleValue,
  PropertyValueIntegerValue,
  PropertyValueStringValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Variant(
    stringValue: Option[PropertyValueStringValue] = None,
    integerValue: Option[PropertyValueIntegerValue] = None,
    doubleValue: Option[PropertyValueDoubleValue] = None,
    booleanValue: Option[PropertyValueBooleanValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Variant = {
    import Variant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Variant
      .builder()
      .optionallyWith(
        stringValue.map(value =>
          PropertyValueStringValue.unwrap(value): java.lang.String
        )
      )(_.stringValue)
      .optionallyWith(
        integerValue.map(value =>
          PropertyValueIntegerValue.unwrap(value): Integer
        )
      )(_.integerValue)
      .optionallyWith(
        doubleValue.map(value =>
          PropertyValueDoubleValue.unwrap(value): java.lang.Double
        )
      )(_.doubleValue)
      .optionallyWith(
        booleanValue.map(value =>
          PropertyValueBooleanValue.unwrap(value): java.lang.Boolean
        )
      )(_.booleanValue)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Variant.ReadOnly =
    zio.aws.iotsitewise.model.Variant.wrap(buildAwsValue())
}
object Variant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Variant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Variant =
      zio.aws.iotsitewise.model.Variant(
        stringValue.map(value => value),
        integerValue.map(value => value),
        doubleValue.map(value => value),
        booleanValue.map(value => value)
      )
    def stringValue: Option[PropertyValueStringValue]
    def integerValue: Option[PropertyValueIntegerValue]
    def doubleValue: Option[PropertyValueDoubleValue]
    def booleanValue: Option[PropertyValueBooleanValue]
    def getStringValue: ZIO[Any, AwsError, PropertyValueStringValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getIntegerValue: ZIO[Any, AwsError, PropertyValueIntegerValue] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getDoubleValue: ZIO[Any, AwsError, PropertyValueDoubleValue] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getBooleanValue: ZIO[Any, AwsError, PropertyValueBooleanValue] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Variant
  ) extends zio.aws.iotsitewise.model.Variant.ReadOnly {
    override val stringValue: Option[PropertyValueStringValue] = scala
      .Option(impl.stringValue())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.PropertyValueStringValue(value)
      )
    override val integerValue: Option[PropertyValueIntegerValue] = scala
      .Option(impl.integerValue())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.PropertyValueIntegerValue(value)
      )
    override val doubleValue: Option[PropertyValueDoubleValue] = scala
      .Option(impl.doubleValue())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.PropertyValueDoubleValue(value)
      )
    override val booleanValue: Option[PropertyValueBooleanValue] = scala
      .Option(impl.booleanValue())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.PropertyValueBooleanValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Variant
  ): zio.aws.iotsitewise.model.Variant.ReadOnly = new Wrapper(impl)
}
