package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  CapabilityConfiguration,
  CapabilityNamespace,
  ID
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateGatewayCapabilityConfigurationRequest(
    gatewayId: ID,
    capabilityNamespace: CapabilityNamespace,
    capabilityConfiguration: CapabilityConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest = {
    import UpdateGatewayCapabilityConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest
      .builder()
      .gatewayId(ID.unwrap(gatewayId): java.lang.String)
      .capabilityNamespace(
        CapabilityNamespace.unwrap(capabilityNamespace): java.lang.String
      )
      .capabilityConfiguration(
        CapabilityConfiguration.unwrap(
          capabilityConfiguration
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateGatewayCapabilityConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest =
      zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest(
        gatewayId,
        capabilityNamespace,
        capabilityConfiguration
      )
    def gatewayId: ID
    def capabilityNamespace: CapabilityNamespace
    def capabilityConfiguration: CapabilityConfiguration
    def getGatewayId: ZIO[Any, Nothing, ID] = ZIO.succeed(gatewayId)
    def getCapabilityNamespace: ZIO[Any, Nothing, CapabilityNamespace] =
      ZIO.succeed(capabilityNamespace)
    def getCapabilityConfiguration: ZIO[Any, Nothing, CapabilityConfiguration] =
      ZIO.succeed(capabilityConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest
  ) extends zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest.ReadOnly {
    override val gatewayId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.gatewayId())
    override val capabilityNamespace: CapabilityNamespace =
      zio.aws.iotsitewise.model.primitives
        .CapabilityNamespace(impl.capabilityNamespace())
    override val capabilityConfiguration: CapabilityConfiguration =
      zio.aws.iotsitewise.model.primitives
        .CapabilityConfiguration(impl.capabilityConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest
  ): zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
