package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Unlimited, NumberOfDays}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RetentionPeriod(
    numberOfDays: Option[NumberOfDays] = None,
    unlimited: Option[Unlimited] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod = {
    import RetentionPeriod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod
      .builder()
      .optionallyWith(
        numberOfDays.map(value => NumberOfDays.unwrap(value): Integer)
      )(_.numberOfDays)
      .optionallyWith(
        unlimited.map(value => Unlimited.unwrap(value): java.lang.Boolean)
      )(_.unlimited)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly =
    zio.aws.iotsitewise.model.RetentionPeriod.wrap(buildAwsValue())
}
object RetentionPeriod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.RetentionPeriod =
      zio.aws.iotsitewise.model.RetentionPeriod(
        numberOfDays.map(value => value),
        unlimited.map(value => value)
      )
    def numberOfDays: Option[NumberOfDays]
    def unlimited: Option[Unlimited]
    def getNumberOfDays: ZIO[Any, AwsError, NumberOfDays] =
      AwsError.unwrapOptionField("numberOfDays", numberOfDays)
    def getUnlimited: ZIO[Any, AwsError, Unlimited] =
      AwsError.unwrapOptionField("unlimited", unlimited)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod
  ) extends zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly {
    override val numberOfDays: Option[NumberOfDays] = scala
      .Option(impl.numberOfDays())
      .map(value => zio.aws.iotsitewise.model.primitives.NumberOfDays(value))
    override val unlimited: Option[Unlimited] = scala
      .Option(impl.unlimited())
      .map(value => zio.aws.iotsitewise.model.primitives.Unlimited(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.RetentionPeriod
  ): zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly = new Wrapper(impl)
}
