package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListProjectAssetsRequest(
    projectId: ID,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest = {
    import ListProjectAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest
      .builder()
      .projectId(ID.unwrap(projectId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListProjectAssetsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListProjectAssetsRequest.wrap(buildAwsValue())
}
object ListProjectAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListProjectAssetsRequest =
      zio.aws.iotsitewise.model.ListProjectAssetsRequest(
        projectId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def projectId: ID
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getProjectId: ZIO[Any, Nothing, ID] = ZIO.succeed(projectId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest
  ) extends zio.aws.iotsitewise.model.ListProjectAssetsRequest.ReadOnly {
    override val projectId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.projectId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsRequest
  ): zio.aws.iotsitewise.model.ListProjectAssetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
