package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssetRelationshipsResponse(
    assetRelationshipSummaries: Iterable[
      zio.aws.iotsitewise.model.AssetRelationshipSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse = {
    import ListAssetRelationshipsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse
      .builder()
      .assetRelationshipSummaries(assetRelationshipSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAssetRelationshipsResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetRelationshipsResponse
      .wrap(buildAwsValue())
}
object ListAssetRelationshipsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetRelationshipsResponse =
      zio.aws.iotsitewise.model.ListAssetRelationshipsResponse(
        assetRelationshipSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def assetRelationshipSummaries
        : List[zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getAssetRelationshipSummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly
    ]] = ZIO.succeed(assetRelationshipSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse
  ) extends zio.aws.iotsitewise.model.ListAssetRelationshipsResponse.ReadOnly {
    override val assetRelationshipSummaries
        : List[zio.aws.iotsitewise.model.AssetRelationshipSummary.ReadOnly] =
      impl
        .assetRelationshipSummaries()
        .asScala
        .map { item =>
          zio.aws.iotsitewise.model.AssetRelationshipSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsResponse
  ): zio.aws.iotsitewise.model.ListAssetRelationshipsResponse.ReadOnly =
    new Wrapper(impl)
}
