package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  NextToken,
  IdentityId,
  MaxResults,
  ARN,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAccessPoliciesRequest(
    identityType: Option[zio.aws.iotsitewise.model.IdentityType] = None,
    identityId: Option[IdentityId] = None,
    resourceType: Option[zio.aws.iotsitewise.model.ResourceType] = None,
    resourceId: Option[ID] = None,
    iamArn: Option[ARN] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest = {
    import ListAccessPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest
      .builder()
      .optionallyWith(identityType.map(value => value.unwrap))(_.identityType)
      .optionallyWith(
        identityId.map(value => IdentityId.unwrap(value): java.lang.String)
      )(_.identityId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceId.map(value => ID.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(iamArn.map(value => ARN.unwrap(value): java.lang.String))(
        _.iamArn
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListAccessPoliciesRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAccessPoliciesRequest.wrap(buildAwsValue())
}
object ListAccessPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAccessPoliciesRequest =
      zio.aws.iotsitewise.model.ListAccessPoliciesRequest(
        identityType.map(value => value),
        identityId.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        iamArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def identityType: Option[zio.aws.iotsitewise.model.IdentityType]
    def identityId: Option[IdentityId]
    def resourceType: Option[zio.aws.iotsitewise.model.ResourceType]
    def resourceId: Option[ID]
    def iamArn: Option[ARN]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getIdentityType
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.IdentityType] =
      AwsError.unwrapOptionField("identityType", identityType)
    def getIdentityId: ZIO[Any, AwsError, IdentityId] =
      AwsError.unwrapOptionField("identityId", identityId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getIamArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("iamArn", iamArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest
  ) extends zio.aws.iotsitewise.model.ListAccessPoliciesRequest.ReadOnly {
    override val identityType: Option[zio.aws.iotsitewise.model.IdentityType] =
      scala
        .Option(impl.identityType())
        .map(value => zio.aws.iotsitewise.model.IdentityType.wrap(value))
    override val identityId: Option[IdentityId] = scala
      .Option(impl.identityId())
      .map(value => zio.aws.iotsitewise.model.primitives.IdentityId(value))
    override val resourceType: Option[zio.aws.iotsitewise.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.iotsitewise.model.ResourceType.wrap(value))
    override val resourceId: Option[ID] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val iamArn: Option[ARN] = scala
      .Option(impl.iamArn())
      .map(value => zio.aws.iotsitewise.model.primitives.ARN(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest
  ): zio.aws.iotsitewise.model.ListAccessPoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
