package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait ForwardingConfigState {
  def unwrap
      : software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState
}
object ForwardingConfigState {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState
  ): zio.aws.iotsitewise.model.ForwardingConfigState = value match {
    case software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.ForwardingConfigState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState =
      software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.iotsitewise.model.ForwardingConfigState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState =
      software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState.DISABLED
  }
  case object ENABLED extends zio.aws.iotsitewise.model.ForwardingConfigState {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState =
      software.amazon.awssdk.services.iotsitewise.model.ForwardingConfigState.ENABLED
  }
}
