package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  TagValue,
  Description,
  ClientToken,
  Name,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAssetModelRequest(
    assetModelName: Name,
    assetModelDescription: Option[Description] = None,
    assetModelProperties: Option[
      Iterable[zio.aws.iotsitewise.model.AssetModelPropertyDefinition]
    ] = None,
    assetModelHierarchies: Option[
      Iterable[zio.aws.iotsitewise.model.AssetModelHierarchyDefinition]
    ] = None,
    assetModelCompositeModels: Option[
      Iterable[zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition]
    ] = None,
    clientToken: Option[ClientToken] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest = {
    import CreateAssetModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest
      .builder()
      .assetModelName(Name.unwrap(assetModelName): java.lang.String)
      .optionallyWith(
        assetModelDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.assetModelDescription)
      .optionallyWith(
        assetModelProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelProperties)
      .optionallyWith(
        assetModelHierarchies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelHierarchies)
      .optionallyWith(
        assetModelCompositeModels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelCompositeModels)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateAssetModelRequest.ReadOnly =
    zio.aws.iotsitewise.model.CreateAssetModelRequest.wrap(buildAwsValue())
}
object CreateAssetModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateAssetModelRequest =
      zio.aws.iotsitewise.model.CreateAssetModelRequest(
        assetModelName,
        assetModelDescription.map(value => value),
        assetModelProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        assetModelHierarchies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        assetModelCompositeModels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def assetModelName: Name
    def assetModelDescription: Option[Description]
    def assetModelProperties: Option[
      List[zio.aws.iotsitewise.model.AssetModelPropertyDefinition.ReadOnly]
    ]
    def assetModelHierarchies: Option[
      List[zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.ReadOnly]
    ]
    def assetModelCompositeModels: Option[List[
      zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition.ReadOnly
    ]]
    def clientToken: Option[ClientToken]
    def tags: Option[Map[TagKey, TagValue]]
    def getAssetModelName: ZIO[Any, Nothing, Name] = ZIO.succeed(assetModelName)
    def getAssetModelDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("assetModelDescription", assetModelDescription)
    def getAssetModelProperties: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelPropertyDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("assetModelProperties", assetModelProperties)
    def getAssetModelHierarchies: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("assetModelHierarchies", assetModelHierarchies)
    def getAssetModelCompositeModels: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "assetModelCompositeModels",
      assetModelCompositeModels
    )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest
  ) extends zio.aws.iotsitewise.model.CreateAssetModelRequest.ReadOnly {
    override val assetModelName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.assetModelName())
    override val assetModelDescription: Option[Description] = scala
      .Option(impl.assetModelDescription())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val assetModelProperties: Option[
      List[zio.aws.iotsitewise.model.AssetModelPropertyDefinition.ReadOnly]
    ] = scala
      .Option(impl.assetModelProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetModelPropertyDefinition.wrap(item)
        }.toList
      )
    override val assetModelHierarchies: Option[
      List[zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.ReadOnly]
    ] = scala
      .Option(impl.assetModelHierarchies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetModelHierarchyDefinition.wrap(item)
        }.toList
      )
    override val assetModelCompositeModels: Option[List[
      zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition.ReadOnly
    ]] = scala
      .Option(impl.assetModelCompositeModels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition
            .wrap(item)
        }.toList
      )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotsitewise.model.primitives.TagKey(
              key
            ) -> zio.aws.iotsitewise.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateAssetModelRequest
  ): zio.aws.iotsitewise.model.CreateAssetModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
