package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AggregatedValue(
    timestamp: Timestamp,
    quality: Option[zio.aws.iotsitewise.model.Quality] = None,
    value: zio.aws.iotsitewise.model.Aggregates
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AggregatedValue = {
    import AggregatedValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AggregatedValue
      .builder()
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .optionallyWith(quality.map(value => value.unwrap))(_.quality)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AggregatedValue.ReadOnly =
    zio.aws.iotsitewise.model.AggregatedValue.wrap(buildAwsValue())
}
object AggregatedValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AggregatedValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AggregatedValue =
      zio.aws.iotsitewise.model.AggregatedValue(
        timestamp,
        quality.map(value => value),
        value.asEditable
      )
    def timestamp: Timestamp
    def quality: Option[zio.aws.iotsitewise.model.Quality]
    def value: zio.aws.iotsitewise.model.Aggregates.ReadOnly
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getQuality: ZIO[Any, AwsError, zio.aws.iotsitewise.model.Quality] =
      AwsError.unwrapOptionField("quality", quality)
    def getValue
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Aggregates.ReadOnly] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AggregatedValue
  ) extends zio.aws.iotsitewise.model.AggregatedValue.ReadOnly {
    override val timestamp: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.timestamp())
    override val quality: Option[zio.aws.iotsitewise.model.Quality] = scala
      .Option(impl.quality())
      .map(value => zio.aws.iotsitewise.model.Quality.wrap(value))
    override val value: zio.aws.iotsitewise.model.Aggregates.ReadOnly =
      zio.aws.iotsitewise.model.Aggregates.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AggregatedValue
  ): zio.aws.iotsitewise.model.AggregatedValue.ReadOnly = new Wrapper(impl)
}
