package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAccessPolicyRequest(
    accessPolicyId: ID,
    accessPolicyIdentity: zio.aws.iotsitewise.model.Identity,
    accessPolicyResource: zio.aws.iotsitewise.model.Resource,
    accessPolicyPermission: zio.aws.iotsitewise.model.Permission,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest = {
    import UpdateAccessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest
      .builder()
      .accessPolicyId(ID.unwrap(accessPolicyId): java.lang.String)
      .accessPolicyIdentity(accessPolicyIdentity.buildAwsValue())
      .accessPolicyResource(accessPolicyResource.buildAwsValue())
      .accessPolicyPermission(accessPolicyPermission.unwrap)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UpdateAccessPolicyRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdateAccessPolicyRequest.wrap(buildAwsValue())
}
object UpdateAccessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdateAccessPolicyRequest =
      zio.aws.iotsitewise.model.UpdateAccessPolicyRequest(
        accessPolicyId,
        accessPolicyIdentity.asEditable,
        accessPolicyResource.asEditable,
        accessPolicyPermission,
        clientToken.map(value => value)
      )
    def accessPolicyId: ID
    def accessPolicyIdentity: zio.aws.iotsitewise.model.Identity.ReadOnly
    def accessPolicyResource: zio.aws.iotsitewise.model.Resource.ReadOnly
    def accessPolicyPermission: zio.aws.iotsitewise.model.Permission
    def clientToken: Option[ClientToken]
    def getAccessPolicyId: ZIO[Any, Nothing, ID] = ZIO.succeed(accessPolicyId)
    def getAccessPolicyIdentity
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Identity.ReadOnly] =
      ZIO.succeed(accessPolicyIdentity)
    def getAccessPolicyResource
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Resource.ReadOnly] =
      ZIO.succeed(accessPolicyResource)
    def getAccessPolicyPermission
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Permission] =
      ZIO.succeed(accessPolicyPermission)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest
  ) extends zio.aws.iotsitewise.model.UpdateAccessPolicyRequest.ReadOnly {
    override val accessPolicyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.accessPolicyId())
    override val accessPolicyIdentity
        : zio.aws.iotsitewise.model.Identity.ReadOnly =
      zio.aws.iotsitewise.model.Identity.wrap(impl.accessPolicyIdentity())
    override val accessPolicyResource
        : zio.aws.iotsitewise.model.Resource.ReadOnly =
      zio.aws.iotsitewise.model.Resource.wrap(impl.accessPolicyResource())
    override val accessPolicyPermission: zio.aws.iotsitewise.model.Permission =
      zio.aws.iotsitewise.model.Permission.wrap(impl.accessPolicyPermission())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAccessPolicyRequest
  ): zio.aws.iotsitewise.model.UpdateAccessPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
