package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{OffsetInNanos, TimeInSeconds}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TimeInNanos(
    timeInSeconds: TimeInSeconds,
    offsetInNanos: Option[OffsetInNanos] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.TimeInNanos = {
    import TimeInNanos.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.TimeInNanos
      .builder()
      .timeInSeconds(TimeInSeconds.unwrap(timeInSeconds): java.lang.Long)
      .optionallyWith(
        offsetInNanos.map(value => OffsetInNanos.unwrap(value): Integer)
      )(_.offsetInNanos)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.TimeInNanos.ReadOnly =
    zio.aws.iotsitewise.model.TimeInNanos.wrap(buildAwsValue())
}
object TimeInNanos {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.TimeInNanos
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.TimeInNanos =
      zio.aws.iotsitewise.model
        .TimeInNanos(timeInSeconds, offsetInNanos.map(value => value))
    def timeInSeconds: TimeInSeconds
    def offsetInNanos: Option[OffsetInNanos]
    def getTimeInSeconds: ZIO[Any, Nothing, TimeInSeconds] =
      ZIO.succeed(timeInSeconds)
    def getOffsetInNanos: ZIO[Any, AwsError, OffsetInNanos] =
      AwsError.unwrapOptionField("offsetInNanos", offsetInNanos)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.TimeInNanos
  ) extends zio.aws.iotsitewise.model.TimeInNanos.ReadOnly {
    override val timeInSeconds: TimeInSeconds =
      zio.aws.iotsitewise.model.primitives.TimeInSeconds(impl.timeInSeconds())
    override val offsetInNanos: Option[OffsetInNanos] = scala
      .Option(impl.offsetInNanos())
      .map(value => zio.aws.iotsitewise.model.primitives.OffsetInNanos(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.TimeInNanos
  ): zio.aws.iotsitewise.model.TimeInNanos.ReadOnly = new Wrapper(impl)
}
