package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MultiLayerStorage(
    customerManagedS3Storage: zio.aws.iotsitewise.model.CustomerManagedS3Storage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.MultiLayerStorage = {
    import MultiLayerStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.MultiLayerStorage
      .builder()
      .customerManagedS3Storage(customerManagedS3Storage.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly =
    zio.aws.iotsitewise.model.MultiLayerStorage.wrap(buildAwsValue())
}
object MultiLayerStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.MultiLayerStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.MultiLayerStorage =
      zio.aws.iotsitewise.model
        .MultiLayerStorage(customerManagedS3Storage.asEditable)
    def customerManagedS3Storage
        : zio.aws.iotsitewise.model.CustomerManagedS3Storage.ReadOnly
    def getCustomerManagedS3Storage: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.CustomerManagedS3Storage.ReadOnly
    ] = ZIO.succeed(customerManagedS3Storage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.MultiLayerStorage
  ) extends zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly {
    override val customerManagedS3Storage
        : zio.aws.iotsitewise.model.CustomerManagedS3Storage.ReadOnly =
      zio.aws.iotsitewise.model.CustomerManagedS3Storage
        .wrap(impl.customerManagedS3Storage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.MultiLayerStorage
  ): zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly = new Wrapper(impl)
}
