package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IAMRoleIdentity(arn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.IAMRoleIdentity = {
    import IAMRoleIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.IAMRoleIdentity
      .builder()
      .arn(ARN.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.IAMRoleIdentity.ReadOnly =
    zio.aws.iotsitewise.model.IAMRoleIdentity.wrap(buildAwsValue())
}
object IAMRoleIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.IAMRoleIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.IAMRoleIdentity =
      zio.aws.iotsitewise.model.IAMRoleIdentity(arn)
    def arn: ARN
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.IAMRoleIdentity
  ) extends zio.aws.iotsitewise.model.IAMRoleIdentity.ReadOnly {
    override val arn: ARN = zio.aws.iotsitewise.model.primitives.ARN(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.IAMRoleIdentity
  ): zio.aws.iotsitewise.model.IAMRoleIdentity.ReadOnly = new Wrapper(impl)
}
