package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAssetPropertyValueHistoryResponse(
    assetPropertyValueHistory: Iterable[
      zio.aws.iotsitewise.model.AssetPropertyValue
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse = {
    import GetAssetPropertyValueHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse
      .builder()
      .assetPropertyValueHistory(assetPropertyValueHistory.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse.ReadOnly =
    zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse
      .wrap(buildAwsValue())
}
object GetAssetPropertyValueHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse =
      zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse(
        assetPropertyValueHistory.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def assetPropertyValueHistory
        : List[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly]
    def nextToken: Option[NextToken]
    def getAssetPropertyValueHistory: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
    ]] = ZIO.succeed(assetPropertyValueHistory)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse
  ) extends zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse.ReadOnly {
    override val assetPropertyValueHistory
        : List[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly] = impl
      .assetPropertyValueHistory()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.AssetPropertyValue.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueHistoryResponse
  ): zio.aws.iotsitewise.model.GetAssetPropertyValueHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
