package zio.aws.iotsitewise.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotsitewise.model.primitives.{
  NextToken,
  AssetPropertyAlias,
  Timestamp,
  MaxResults,
  Resolution,
  ID
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetAssetPropertyAggregatesRequest(
    assetId: Option[ID] = None,
    propertyId: Option[ID] = None,
    propertyAlias: Option[AssetPropertyAlias] = None,
    aggregateTypes: Iterable[zio.aws.iotsitewise.model.AggregateType],
    resolution: Resolution,
    qualities: Option[Iterable[zio.aws.iotsitewise.model.Quality]] = None,
    startDate: Timestamp,
    endDate: Timestamp,
    timeOrdering: Option[zio.aws.iotsitewise.model.TimeOrdering] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest = {
    import GetAssetPropertyAggregatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest
      .builder()
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        propertyAlias.map(value =>
          AssetPropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .aggregateTypesWithStrings(aggregateTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .resolution(Resolution.unwrap(resolution): java.lang.String)
      .optionallyWith(
        qualities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.qualitiesWithStrings)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .endDate(Timestamp.unwrap(endDate): Instant)
      .optionallyWith(timeOrdering.map(value => value.unwrap))(_.timeOrdering)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest.ReadOnly =
    zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest
      .wrap(buildAwsValue())
}
object GetAssetPropertyAggregatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest =
      zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest(
        assetId.map(value => value),
        propertyId.map(value => value),
        propertyAlias.map(value => value),
        aggregateTypes,
        resolution,
        qualities.map(value => value),
        startDate,
        endDate,
        timeOrdering.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assetId: Option[ID]
    def propertyId: Option[ID]
    def propertyAlias: Option[AssetPropertyAlias]
    def aggregateTypes: List[zio.aws.iotsitewise.model.AggregateType]
    def resolution: Resolution
    def qualities: Option[List[zio.aws.iotsitewise.model.Quality]]
    def startDate: Timestamp
    def endDate: Timestamp
    def timeOrdering: Option[zio.aws.iotsitewise.model.TimeOrdering]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, AssetPropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getAggregateTypes
        : ZIO[Any, Nothing, List[zio.aws.iotsitewise.model.AggregateType]] =
      ZIO.succeed(aggregateTypes)
    def getResolution: ZIO[Any, Nothing, Resolution] = ZIO.succeed(resolution)
    def getQualities
        : ZIO[Any, AwsError, List[zio.aws.iotsitewise.model.Quality]] =
      AwsError.unwrapOptionField("qualities", qualities)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getEndDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDate)
    def getTimeOrdering
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.TimeOrdering] =
      AwsError.unwrapOptionField("timeOrdering", timeOrdering)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ) extends zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest.ReadOnly {
    override val assetId: Option[ID] = scala
      .Option(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Option[ID] = scala
      .Option(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyAlias: Option[AssetPropertyAlias] = scala
      .Option(impl.propertyAlias())
      .map(value =>
        zio.aws.iotsitewise.model.primitives.AssetPropertyAlias(value)
      )
    override val aggregateTypes: List[zio.aws.iotsitewise.model.AggregateType] =
      impl
        .aggregateTypes()
        .asScala
        .map { item =>
          zio.aws.iotsitewise.model.AggregateType.wrap(item)
        }
        .toList
    override val resolution: Resolution =
      zio.aws.iotsitewise.model.primitives.Resolution(impl.resolution())
    override val qualities: Option[List[zio.aws.iotsitewise.model.Quality]] =
      scala
        .Option(impl.qualities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.Quality.wrap(item)
          }.toList
        )
    override val startDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.startDate())
    override val endDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.endDate())
    override val timeOrdering: Option[zio.aws.iotsitewise.model.TimeOrdering] =
      scala
        .Option(impl.timeOrdering())
        .map(value => zio.aws.iotsitewise.model.TimeOrdering.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest
  ): zio.aws.iotsitewise.model.GetAssetPropertyAggregatesRequest.ReadOnly =
    new Wrapper(impl)
}
