package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteAssetModelRequest(
    assetModelId: ID,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest = {
    import DeleteAssetModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest
      .builder()
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DeleteAssetModelRequest.ReadOnly =
    zio.aws.iotsitewise.model.DeleteAssetModelRequest.wrap(buildAwsValue())
}
object DeleteAssetModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DeleteAssetModelRequest =
      zio.aws.iotsitewise.model
        .DeleteAssetModelRequest(assetModelId, clientToken.map(value => value))
    def assetModelId: ID
    def clientToken: Option[ClientToken]
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest
  ) extends zio.aws.iotsitewise.model.DeleteAssetModelRequest.ReadOnly {
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteAssetModelRequest
  ): zio.aws.iotsitewise.model.DeleteAssetModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
