package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.EntryId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchPutAssetPropertyErrorEntry(
    entryId: EntryId,
    errors: Iterable[zio.aws.iotsitewise.model.BatchPutAssetPropertyError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyErrorEntry = {
    import BatchPutAssetPropertyErrorEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyErrorEntry
      .builder()
      .entryId(EntryId.unwrap(entryId): java.lang.String)
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry.ReadOnly =
    zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry
      .wrap(buildAwsValue())
}
object BatchPutAssetPropertyErrorEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyErrorEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry =
      zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry(
        entryId,
        errors.map { item =>
          item.asEditable
        }
      )
    def entryId: EntryId
    def errors
        : List[zio.aws.iotsitewise.model.BatchPutAssetPropertyError.ReadOnly]
    def getEntryId: ZIO[Any, Nothing, EntryId] = ZIO.succeed(entryId)
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.BatchPutAssetPropertyError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyErrorEntry
  ) extends zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry.ReadOnly {
    override val entryId: EntryId =
      zio.aws.iotsitewise.model.primitives.EntryId(impl.entryId())
    override val errors
        : List[zio.aws.iotsitewise.model.BatchPutAssetPropertyError.ReadOnly] =
      impl
        .errors()
        .asScala
        .map { item =>
          zio.aws.iotsitewise.model.BatchPutAssetPropertyError.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.BatchPutAssetPropertyErrorEntry
  ): zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry.ReadOnly =
    new Wrapper(impl)
}
