package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  PropertyUnit,
  PropertyAlias,
  Name,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssetProperty(
    id: ID,
    name: Name,
    alias: Option[PropertyAlias] = None,
    notification: Option[zio.aws.iotsitewise.model.PropertyNotification] = None,
    dataType: zio.aws.iotsitewise.model.PropertyDataType,
    dataTypeSpec: Option[Name] = None,
    unit: Option[PropertyUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetProperty = {
    import AssetProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetProperty
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        alias.map(value => PropertyAlias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(notification.map(value => value.buildAwsValue()))(
        _.notification
      )
      .dataType(dataType.unwrap)
      .optionallyWith(
        dataTypeSpec.map(value => Name.unwrap(value): java.lang.String)
      )(_.dataTypeSpec)
      .optionallyWith(
        unit.map(value => PropertyUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetProperty.ReadOnly =
    zio.aws.iotsitewise.model.AssetProperty.wrap(buildAwsValue())
}
object AssetProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetProperty =
      zio.aws.iotsitewise.model.AssetProperty(
        id,
        name,
        alias.map(value => value),
        notification.map(value => value.asEditable),
        dataType,
        dataTypeSpec.map(value => value),
        unit.map(value => value)
      )
    def id: ID
    def name: Name
    def alias: Option[PropertyAlias]
    def notification
        : Option[zio.aws.iotsitewise.model.PropertyNotification.ReadOnly]
    def dataType: zio.aws.iotsitewise.model.PropertyDataType
    def dataTypeSpec: Option[Name]
    def unit: Option[PropertyUnit]
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getAlias: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getNotification: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.PropertyNotification.ReadOnly
    ] = AwsError.unwrapOptionField("notification", notification)
    def getDataType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PropertyDataType] =
      ZIO.succeed(dataType)
    def getDataTypeSpec: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("dataTypeSpec", dataTypeSpec)
    def getUnit: ZIO[Any, AwsError, PropertyUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetProperty
  ) extends zio.aws.iotsitewise.model.AssetProperty.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val alias: Option[PropertyAlias] = scala
      .Option(impl.alias())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val notification
        : Option[zio.aws.iotsitewise.model.PropertyNotification.ReadOnly] =
      scala
        .Option(impl.notification())
        .map(value =>
          zio.aws.iotsitewise.model.PropertyNotification.wrap(value)
        )
    override val dataType: zio.aws.iotsitewise.model.PropertyDataType =
      zio.aws.iotsitewise.model.PropertyDataType.wrap(impl.dataType())
    override val dataTypeSpec: Option[Name] = scala
      .Option(impl.dataTypeSpec())
      .map(value => zio.aws.iotsitewise.model.primitives.Name(value))
    override val unit: Option[PropertyUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyUnit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetProperty
  ): zio.aws.iotsitewise.model.AssetProperty.ReadOnly = new Wrapper(impl)
}
