package zio.aws.iotsitewise
import zio.aws.iotsitewise.model.primitives.TimeInSeconds.Type
import java.time.Instant
import zio.aws.iotsitewise.model.primitives.{TagValue, TagKey, ID}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.iotsitewise.model.primitives.ARN.Type
    object AggregatedDoubleValue extends Subtype[Double]
    type AggregatedDoubleValue =
      zio.aws.iotsitewise.model.primitives.AggregatedDoubleValue.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.iotsitewise.model.primitives.AmazonResourceName.Type
    object AssetErrorMessage extends Subtype[String]
    type AssetErrorMessage =
      zio.aws.iotsitewise.model.primitives.AssetErrorMessage.Type
    object AssetPropertyAlias extends Subtype[String]
    type AssetPropertyAlias =
      zio.aws.iotsitewise.model.primitives.AssetPropertyAlias.Type
    object CapabilityConfiguration extends Subtype[String]
    type CapabilityConfiguration =
      zio.aws.iotsitewise.model.primitives.CapabilityConfiguration.Type
    object CapabilityNamespace extends Subtype[String]
    type CapabilityNamespace =
      zio.aws.iotsitewise.model.primitives.CapabilityNamespace.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.iotsitewise.model.primitives.ClientToken.Type
    object CoreDeviceThingName extends Subtype[String]
    type CoreDeviceThingName =
      zio.aws.iotsitewise.model.primitives.CoreDeviceThingName.Type
    object DashboardDefinition extends Subtype[String]
    type DashboardDefinition =
      zio.aws.iotsitewise.model.primitives.DashboardDefinition.Type
    object DefaultValue extends Subtype[String]
    type DefaultValue = zio.aws.iotsitewise.model.primitives.DefaultValue.Type
    object Description extends Subtype[String]
    type Description = zio.aws.iotsitewise.model.primitives.Description.Type
    object DetailedErrorMessage extends Subtype[String]
    type DetailedErrorMessage =
      zio.aws.iotsitewise.model.primitives.DetailedErrorMessage.Type
    object Email extends Subtype[String]
    type Email = zio.aws.iotsitewise.model.primitives.Email.Type
    object EntryId extends Subtype[String]
    type EntryId = zio.aws.iotsitewise.model.primitives.EntryId.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.iotsitewise.model.primitives.ErrorMessage.Type
    object Expression extends Subtype[String]
    type Expression = zio.aws.iotsitewise.model.primitives.Expression.Type
    object ID extends Subtype[String]
    type ID = zio.aws.iotsitewise.model.primitives.ID.Type
    object IdentityId extends Subtype[String]
    type IdentityId = zio.aws.iotsitewise.model.primitives.IdentityId.Type
    object ImageFileData extends Subtype[Chunk[Byte]]
    type ImageFileData = zio.aws.iotsitewise.model.primitives.ImageFileData.Type
    object InterpolationType extends Subtype[String]
    type InterpolationType =
      zio.aws.iotsitewise.model.primitives.InterpolationType.Type
    object Interval extends Subtype[String]
    type Interval = zio.aws.iotsitewise.model.primitives.Interval.Type
    object IntervalInSeconds extends Subtype[Long]
    type IntervalInSeconds =
      zio.aws.iotsitewise.model.primitives.IntervalInSeconds.Type
    object IntervalWindowInSeconds extends Subtype[Long]
    type IntervalWindowInSeconds =
      zio.aws.iotsitewise.model.primitives.IntervalWindowInSeconds.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.iotsitewise.model.primitives.KmsKeyId.Type
    object Macro extends Subtype[String]
    type Macro = zio.aws.iotsitewise.model.primitives.Macro.Type
    object MaxInterpolatedResults extends Subtype[Int]
    type MaxInterpolatedResults =
      zio.aws.iotsitewise.model.primitives.MaxInterpolatedResults.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.iotsitewise.model.primitives.MaxResults.Type
    object MonitorErrorMessage extends Subtype[String]
    type MonitorErrorMessage =
      zio.aws.iotsitewise.model.primitives.MonitorErrorMessage.Type
    object Name extends Subtype[String]
    type Name = zio.aws.iotsitewise.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.iotsitewise.model.primitives.NextToken.Type
    object NumberOfDays extends Subtype[Int]
    type NumberOfDays = zio.aws.iotsitewise.model.primitives.NumberOfDays.Type
    object Offset extends Subtype[String]
    type Offset = zio.aws.iotsitewise.model.primitives.Offset.Type
    object OffsetInNanos extends Subtype[Int]
    type OffsetInNanos = zio.aws.iotsitewise.model.primitives.OffsetInNanos.Type
    object PortalClientId extends Subtype[String]
    type PortalClientId =
      zio.aws.iotsitewise.model.primitives.PortalClientId.Type
    object PropertyAlias extends Subtype[String]
    type PropertyAlias = zio.aws.iotsitewise.model.primitives.PropertyAlias.Type
    object PropertyNotificationTopic extends Subtype[String]
    type PropertyNotificationTopic =
      zio.aws.iotsitewise.model.primitives.PropertyNotificationTopic.Type
    object PropertyUnit extends Subtype[String]
    type PropertyUnit = zio.aws.iotsitewise.model.primitives.PropertyUnit.Type
    object PropertyValueBooleanValue extends Subtype[Boolean]
    type PropertyValueBooleanValue =
      zio.aws.iotsitewise.model.primitives.PropertyValueBooleanValue.Type
    object PropertyValueDoubleValue extends Subtype[Double]
    type PropertyValueDoubleValue =
      zio.aws.iotsitewise.model.primitives.PropertyValueDoubleValue.Type
    object PropertyValueIntegerValue extends Subtype[Int]
    type PropertyValueIntegerValue =
      zio.aws.iotsitewise.model.primitives.PropertyValueIntegerValue.Type
    object PropertyValueStringValue extends Subtype[String]
    type PropertyValueStringValue =
      zio.aws.iotsitewise.model.primitives.PropertyValueStringValue.Type
    object Resolution extends Subtype[String]
    type Resolution = zio.aws.iotsitewise.model.primitives.Resolution.Type
    object SSOApplicationId extends Subtype[String]
    type SSOApplicationId =
      zio.aws.iotsitewise.model.primitives.SSOApplicationId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.iotsitewise.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.iotsitewise.model.primitives.TagValue.Type
    object TimeInSeconds extends Subtype[Long]
    type TimeInSeconds = zio.aws.iotsitewise.model.primitives.TimeInSeconds.Type
    object TimeSeriesId extends Subtype[String]
    type TimeSeriesId = zio.aws.iotsitewise.model.primitives.TimeSeriesId.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.iotsitewise.model.primitives.Timestamp.Type
    object Unlimited extends Subtype[Boolean]
    type Unlimited = zio.aws.iotsitewise.model.primitives.Unlimited.Type
    object Url extends Subtype[String]
    type Url = zio.aws.iotsitewise.model.primitives.Url.Type
    object VariableName extends Subtype[String]
    type VariableName = zio.aws.iotsitewise.model.primitives.VariableName.Type
  }
  type AccessPolicySummaries =
    List[zio.aws.iotsitewise.model.AccessPolicySummary]
  type AggregateTypes = List[zio.aws.iotsitewise.model.AggregateType]
  type AggregatedValues = List[zio.aws.iotsitewise.model.AggregatedValue]
  type AssetCompositeModels =
    List[zio.aws.iotsitewise.model.AssetCompositeModel]
  type AssetHierarchies = List[zio.aws.iotsitewise.model.AssetHierarchy]
  type AssetIDs = List[ID]
  type AssetModelCompositeModelDefinitions =
    List[zio.aws.iotsitewise.model.AssetModelCompositeModelDefinition]
  type AssetModelCompositeModels =
    List[zio.aws.iotsitewise.model.AssetModelCompositeModel]
  type AssetModelHierarchies =
    List[zio.aws.iotsitewise.model.AssetModelHierarchy]
  type AssetModelHierarchyDefinitions =
    List[zio.aws.iotsitewise.model.AssetModelHierarchyDefinition]
  type AssetModelProperties = List[zio.aws.iotsitewise.model.AssetModelProperty]
  type AssetModelPropertyDefinitions =
    List[zio.aws.iotsitewise.model.AssetModelPropertyDefinition]
  type AssetModelSummaries = List[zio.aws.iotsitewise.model.AssetModelSummary]
  type AssetProperties = List[zio.aws.iotsitewise.model.AssetProperty]
  type AssetPropertyValueHistory =
    List[zio.aws.iotsitewise.model.AssetPropertyValue]
  type AssetPropertyValues = List[zio.aws.iotsitewise.model.AssetPropertyValue]
  type AssetRelationshipSummaries =
    List[zio.aws.iotsitewise.model.AssetRelationshipSummary]
  type AssetSummaries = List[zio.aws.iotsitewise.model.AssetSummary]
  type AssociatedAssetsSummaries =
    List[zio.aws.iotsitewise.model.AssociatedAssetsSummary]
  type BatchAssociateProjectAssetsErrors =
    List[zio.aws.iotsitewise.model.AssetErrorDetails]
  type BatchDisassociateProjectAssetsErrors =
    List[zio.aws.iotsitewise.model.AssetErrorDetails]
  type BatchPutAssetPropertyErrorEntries =
    List[zio.aws.iotsitewise.model.BatchPutAssetPropertyErrorEntry]
  type BatchPutAssetPropertyErrors =
    List[zio.aws.iotsitewise.model.BatchPutAssetPropertyError]
  type DashboardSummaries = List[zio.aws.iotsitewise.model.DashboardSummary]
  type DetailedErrors = List[zio.aws.iotsitewise.model.DetailedError]
  type ExpressionVariables = List[zio.aws.iotsitewise.model.ExpressionVariable]
  type GatewayCapabilitySummaries =
    List[zio.aws.iotsitewise.model.GatewayCapabilitySummary]
  type GatewaySummaries = List[zio.aws.iotsitewise.model.GatewaySummary]
  type IDs = List[ID]
  type InterpolatedAssetPropertyValues =
    List[zio.aws.iotsitewise.model.InterpolatedAssetPropertyValue]
  type PortalSummaries = List[zio.aws.iotsitewise.model.PortalSummary]
  type ProjectSummaries = List[zio.aws.iotsitewise.model.ProjectSummary]
  type PutAssetPropertyValueEntries =
    List[zio.aws.iotsitewise.model.PutAssetPropertyValueEntry]
  type Qualities = List[zio.aws.iotsitewise.model.Quality]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TimeSeriesSummaries = List[zio.aws.iotsitewise.model.TimeSeriesSummary]
  type Timestamps = List[zio.aws.iotsitewise.model.TimeInNanos]
}
