package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.CapabilityNamespace
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateGatewayCapabilityConfigurationResponse(
    capabilityNamespace: CapabilityNamespace,
    capabilitySyncStatus: zio.aws.iotsitewise.model.CapabilitySyncStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse = {
    import UpdateGatewayCapabilityConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse
      .builder()
      .capabilityNamespace(
        CapabilityNamespace.unwrap(capabilityNamespace): java.lang.String
      )
      .capabilitySyncStatus(capabilitySyncStatus.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse.ReadOnly =
    zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateGatewayCapabilityConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse =
      zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse(
        capabilityNamespace,
        capabilitySyncStatus
      )
    def capabilityNamespace: CapabilityNamespace
    def capabilitySyncStatus: zio.aws.iotsitewise.model.CapabilitySyncStatus
    def getCapabilityNamespace: ZIO[Any, Nothing, CapabilityNamespace] =
      ZIO.succeed(capabilityNamespace)
    def getCapabilitySyncStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.CapabilitySyncStatus] =
      ZIO.succeed(capabilitySyncStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse
  ) extends zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse.ReadOnly {
    override val capabilityNamespace: CapabilityNamespace =
      zio.aws.iotsitewise.model.primitives
        .CapabilityNamespace(impl.capabilityNamespace())
    override val capabilitySyncStatus
        : zio.aws.iotsitewise.model.CapabilitySyncStatus =
      zio.aws.iotsitewise.model.CapabilitySyncStatus
        .wrap(impl.capabilitySyncStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse
  ): zio.aws.iotsitewise.model.UpdateGatewayCapabilityConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
