package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Resource(
    portal: Option[zio.aws.iotsitewise.model.PortalResource] = None,
    project: Option[zio.aws.iotsitewise.model.ProjectResource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Resource
      .builder()
      .optionallyWith(portal.map(value => value.buildAwsValue()))(_.portal)
      .optionallyWith(project.map(value => value.buildAwsValue()))(_.project)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Resource.ReadOnly =
    zio.aws.iotsitewise.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Resource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Resource =
      zio.aws.iotsitewise.model.Resource(
        portal.map(value => value.asEditable),
        project.map(value => value.asEditable)
      )
    def portal: Option[zio.aws.iotsitewise.model.PortalResource.ReadOnly]
    def project: Option[zio.aws.iotsitewise.model.ProjectResource.ReadOnly]
    def getPortal: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.PortalResource.ReadOnly
    ] = AwsError.unwrapOptionField("portal", portal)
    def getProject: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.ProjectResource.ReadOnly
    ] = AwsError.unwrapOptionField("project", project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Resource
  ) extends zio.aws.iotsitewise.model.Resource.ReadOnly {
    override val portal
        : Option[zio.aws.iotsitewise.model.PortalResource.ReadOnly] = scala
      .Option(impl.portal())
      .map(value => zio.aws.iotsitewise.model.PortalResource.wrap(value))
    override val project
        : Option[zio.aws.iotsitewise.model.ProjectResource.ReadOnly] = scala
      .Option(impl.project())
      .map(value => zio.aws.iotsitewise.model.ProjectResource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Resource
  ): zio.aws.iotsitewise.model.Resource.ReadOnly = new Wrapper(impl)
}
