package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutStorageConfigurationRequest(
    storageType: zio.aws.iotsitewise.model.StorageType,
    multiLayerStorage: Option[zio.aws.iotsitewise.model.MultiLayerStorage] =
      None,
    disassociatedDataStorage: Option[
      zio.aws.iotsitewise.model.DisassociatedDataStorageState
    ] = None,
    retentionPeriod: Option[zio.aws.iotsitewise.model.RetentionPeriod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest = {
    import PutStorageConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest
      .builder()
      .storageType(storageType.unwrap)
      .optionallyWith(multiLayerStorage.map(value => value.buildAwsValue()))(
        _.multiLayerStorage
      )
      .optionallyWith(disassociatedDataStorage.map(value => value.unwrap))(
        _.disassociatedDataStorage
      )
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.PutStorageConfigurationRequest.ReadOnly =
    zio.aws.iotsitewise.model.PutStorageConfigurationRequest
      .wrap(buildAwsValue())
}
object PutStorageConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.PutStorageConfigurationRequest =
      zio.aws.iotsitewise.model.PutStorageConfigurationRequest(
        storageType,
        multiLayerStorage.map(value => value.asEditable),
        disassociatedDataStorage.map(value => value),
        retentionPeriod.map(value => value.asEditable)
      )
    def storageType: zio.aws.iotsitewise.model.StorageType
    def multiLayerStorage
        : Option[zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly]
    def disassociatedDataStorage
        : Option[zio.aws.iotsitewise.model.DisassociatedDataStorageState]
    def retentionPeriod
        : Option[zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly]
    def getStorageType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.StorageType] =
      ZIO.succeed(storageType)
    def getMultiLayerStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly
    ] = AwsError.unwrapOptionField("multiLayerStorage", multiLayerStorage)
    def getDisassociatedDataStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.DisassociatedDataStorageState
    ] = AwsError.unwrapOptionField(
      "disassociatedDataStorage",
      disassociatedDataStorage
    )
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest
  ) extends zio.aws.iotsitewise.model.PutStorageConfigurationRequest.ReadOnly {
    override val storageType: zio.aws.iotsitewise.model.StorageType =
      zio.aws.iotsitewise.model.StorageType.wrap(impl.storageType())
    override val multiLayerStorage
        : Option[zio.aws.iotsitewise.model.MultiLayerStorage.ReadOnly] = scala
      .Option(impl.multiLayerStorage())
      .map(value => zio.aws.iotsitewise.model.MultiLayerStorage.wrap(value))
    override val disassociatedDataStorage
        : Option[zio.aws.iotsitewise.model.DisassociatedDataStorageState] =
      scala
        .Option(impl.disassociatedDataStorage())
        .map(value =>
          zio.aws.iotsitewise.model.DisassociatedDataStorageState.wrap(value)
        )
    override val retentionPeriod
        : Option[zio.aws.iotsitewise.model.RetentionPeriod.ReadOnly] = scala
      .Option(impl.retentionPeriod())
      .map(value => zio.aws.iotsitewise.model.RetentionPeriod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutStorageConfigurationRequest
  ): zio.aws.iotsitewise.model.PutStorageConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
