package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ID, MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssetsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    assetModelId: Option[ID] = None,
    filter: Option[zio.aws.iotsitewise.model.ListAssetsFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest = {
    import ListAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        assetModelId.map(value => ID.unwrap(value): java.lang.String)
      )(_.assetModelId)
      .optionallyWith(filter.map(value => value.unwrap))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListAssetsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetsRequest.wrap(buildAwsValue())
}
object ListAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetsRequest =
      zio.aws.iotsitewise.model.ListAssetsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        assetModelId.map(value => value),
        filter.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def assetModelId: Option[ID]
    def filter: Option[zio.aws.iotsitewise.model.ListAssetsFilter]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAssetModelId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetModelId", assetModelId)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ListAssetsFilter] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest
  ) extends zio.aws.iotsitewise.model.ListAssetsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
    override val assetModelId: Option[ID] = scala
      .Option(impl.assetModelId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val filter: Option[zio.aws.iotsitewise.model.ListAssetsFilter] =
      scala
        .Option(impl.filter())
        .map(value => zio.aws.iotsitewise.model.ListAssetsFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetsRequest
  ): zio.aws.iotsitewise.model.ListAssetsRequest.ReadOnly = new Wrapper(impl)
}
