package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Identity(
    user: Option[zio.aws.iotsitewise.model.UserIdentity] = None,
    group: Option[zio.aws.iotsitewise.model.GroupIdentity] = None,
    iamUser: Option[zio.aws.iotsitewise.model.IAMUserIdentity] = None,
    iamRole: Option[zio.aws.iotsitewise.model.IAMRoleIdentity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Identity = {
    import Identity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Identity
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .optionallyWith(iamUser.map(value => value.buildAwsValue()))(_.iamUser)
      .optionallyWith(iamRole.map(value => value.buildAwsValue()))(_.iamRole)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Identity.ReadOnly =
    zio.aws.iotsitewise.model.Identity.wrap(buildAwsValue())
}
object Identity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Identity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Identity =
      zio.aws.iotsitewise.model.Identity(
        user.map(value => value.asEditable),
        group.map(value => value.asEditable),
        iamUser.map(value => value.asEditable),
        iamRole.map(value => value.asEditable)
      )
    def user: Option[zio.aws.iotsitewise.model.UserIdentity.ReadOnly]
    def group: Option[zio.aws.iotsitewise.model.GroupIdentity.ReadOnly]
    def iamUser: Option[zio.aws.iotsitewise.model.IAMUserIdentity.ReadOnly]
    def iamRole: Option[zio.aws.iotsitewise.model.IAMRoleIdentity.ReadOnly]
    def getUser
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.UserIdentity.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
    def getGroup
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.GroupIdentity.ReadOnly] =
      AwsError.unwrapOptionField("group", group)
    def getIamUser: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.IAMUserIdentity.ReadOnly
    ] = AwsError.unwrapOptionField("iamUser", iamUser)
    def getIamRole: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.IAMRoleIdentity.ReadOnly
    ] = AwsError.unwrapOptionField("iamRole", iamRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Identity
  ) extends zio.aws.iotsitewise.model.Identity.ReadOnly {
    override val user: Option[zio.aws.iotsitewise.model.UserIdentity.ReadOnly] =
      scala
        .Option(impl.user())
        .map(value => zio.aws.iotsitewise.model.UserIdentity.wrap(value))
    override val group
        : Option[zio.aws.iotsitewise.model.GroupIdentity.ReadOnly] = scala
      .Option(impl.group())
      .map(value => zio.aws.iotsitewise.model.GroupIdentity.wrap(value))
    override val iamUser
        : Option[zio.aws.iotsitewise.model.IAMUserIdentity.ReadOnly] = scala
      .Option(impl.iamUser())
      .map(value => zio.aws.iotsitewise.model.IAMUserIdentity.wrap(value))
    override val iamRole
        : Option[zio.aws.iotsitewise.model.IAMRoleIdentity.ReadOnly] = scala
      .Option(impl.iamRole())
      .map(value => zio.aws.iotsitewise.model.IAMRoleIdentity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Identity
  ): zio.aws.iotsitewise.model.Identity.ReadOnly = new Wrapper(impl)
}
