package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ErrorMessage
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ErrorDetails(
    code: zio.aws.iotsitewise.model.ErrorCode,
    message: ErrorMessage,
    details: Option[Iterable[zio.aws.iotsitewise.model.DetailedError]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ErrorDetails
      .builder()
      .code(code.unwrap)
      .message(ErrorMessage.unwrap(message): java.lang.String)
      .optionallyWith(
        details.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.details)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ErrorDetails.ReadOnly =
    zio.aws.iotsitewise.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ErrorDetails =
      zio.aws.iotsitewise.model.ErrorDetails(
        code,
        message,
        details.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def code: zio.aws.iotsitewise.model.ErrorCode
    def message: ErrorMessage
    def details: Option[List[zio.aws.iotsitewise.model.DetailedError.ReadOnly]]
    def getCode: ZIO[Any, Nothing, zio.aws.iotsitewise.model.ErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, ErrorMessage] = ZIO.succeed(message)
    def getDetails: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.DetailedError.ReadOnly
    ]] = AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ErrorDetails
  ) extends zio.aws.iotsitewise.model.ErrorDetails.ReadOnly {
    override val code: zio.aws.iotsitewise.model.ErrorCode =
      zio.aws.iotsitewise.model.ErrorCode.wrap(impl.code())
    override val message: ErrorMessage =
      zio.aws.iotsitewise.model.primitives.ErrorMessage(impl.message())
    override val details
        : Option[List[zio.aws.iotsitewise.model.DetailedError.ReadOnly]] = scala
      .Option(impl.details())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.DetailedError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ErrorDetails
  ): zio.aws.iotsitewise.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
