package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConfigurationStatus(
    state: zio.aws.iotsitewise.model.ConfigurationState,
    error: Option[zio.aws.iotsitewise.model.ConfigurationErrorDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ConfigurationStatus = {
    import ConfigurationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ConfigurationStatus
      .builder()
      .state(state.unwrap)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly =
    zio.aws.iotsitewise.model.ConfigurationStatus.wrap(buildAwsValue())
}
object ConfigurationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ConfigurationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ConfigurationStatus =
      zio.aws.iotsitewise.model
        .ConfigurationStatus(state, error.map(value => value.asEditable))
    def state: zio.aws.iotsitewise.model.ConfigurationState
    def error
        : Option[zio.aws.iotsitewise.model.ConfigurationErrorDetails.ReadOnly]
    def getState
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.ConfigurationState] =
      ZIO.succeed(state)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.ConfigurationErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ConfigurationStatus
  ) extends zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly {
    override val state: zio.aws.iotsitewise.model.ConfigurationState =
      zio.aws.iotsitewise.model.ConfigurationState.wrap(impl.state())
    override val error
        : Option[zio.aws.iotsitewise.model.ConfigurationErrorDetails.ReadOnly] =
      scala
        .Option(impl.error())
        .map(value =>
          zio.aws.iotsitewise.model.ConfigurationErrorDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ConfigurationStatus
  ): zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly = new Wrapper(impl)
}
