package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssetModelHierarchy(
    id: Option[ID] = None,
    name: Name,
    childAssetModelId: ID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy = {
    import AssetModelHierarchy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .name(Name.unwrap(name): java.lang.String)
      .childAssetModelId(ID.unwrap(childAssetModelId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetModelHierarchy.ReadOnly =
    zio.aws.iotsitewise.model.AssetModelHierarchy.wrap(buildAwsValue())
}
object AssetModelHierarchy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetModelHierarchy =
      zio.aws.iotsitewise.model
        .AssetModelHierarchy(id.map(value => value), name, childAssetModelId)
    def id: Option[ID]
    def name: Name
    def childAssetModelId: ID
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getChildAssetModelId: ZIO[Any, Nothing, ID] =
      ZIO.succeed(childAssetModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy
  ) extends zio.aws.iotsitewise.model.AssetModelHierarchy.ReadOnly {
    override val id: Option[ID] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val childAssetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.childAssetModelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy
  ): zio.aws.iotsitewise.model.AssetModelHierarchy.ReadOnly = new Wrapper(impl)
}
