package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Timestamp, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AccessPolicySummary(
    id: ID,
    identity: zio.aws.iotsitewise.model.Identity,
    resource: zio.aws.iotsitewise.model.Resource,
    permission: zio.aws.iotsitewise.model.Permission,
    creationDate: Option[Timestamp] = None,
    lastUpdateDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AccessPolicySummary = {
    import AccessPolicySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AccessPolicySummary
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .identity(identity.buildAwsValue())
      .resource(resource.buildAwsValue())
      .permission(permission.unwrap)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastUpdateDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateDate)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly =
    zio.aws.iotsitewise.model.AccessPolicySummary.wrap(buildAwsValue())
}
object AccessPolicySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AccessPolicySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AccessPolicySummary =
      zio.aws.iotsitewise.model.AccessPolicySummary(
        id,
        identity.asEditable,
        resource.asEditable,
        permission,
        creationDate.map(value => value),
        lastUpdateDate.map(value => value)
      )
    def id: ID
    def identity: zio.aws.iotsitewise.model.Identity.ReadOnly
    def resource: zio.aws.iotsitewise.model.Resource.ReadOnly
    def permission: zio.aws.iotsitewise.model.Permission
    def creationDate: Option[Timestamp]
    def lastUpdateDate: Option[Timestamp]
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getIdentity
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Identity.ReadOnly] =
      ZIO.succeed(identity)
    def getResource
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Resource.ReadOnly] =
      ZIO.succeed(resource)
    def getPermission: ZIO[Any, Nothing, zio.aws.iotsitewise.model.Permission] =
      ZIO.succeed(permission)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AccessPolicySummary
  ) extends zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val identity: zio.aws.iotsitewise.model.Identity.ReadOnly =
      zio.aws.iotsitewise.model.Identity.wrap(impl.identity())
    override val resource: zio.aws.iotsitewise.model.Resource.ReadOnly =
      zio.aws.iotsitewise.model.Resource.wrap(impl.resource())
    override val permission: zio.aws.iotsitewise.model.Permission =
      zio.aws.iotsitewise.model.Permission.wrap(impl.permission())
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
    override val lastUpdateDate: Option[Timestamp] = scala
      .Option(impl.lastUpdateDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AccessPolicySummary
  ): zio.aws.iotsitewise.model.AccessPolicySummary.ReadOnly = new Wrapper(impl)
}
