package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, Description, Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateProjectRequest(
    projectId: ID,
    projectName: Name,
    projectDescription: Option[Description] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest
      .builder()
      .projectId(ID.unwrap(projectId): java.lang.String)
      .projectName(Name.unwrap(projectName): java.lang.String)
      .optionallyWith(
        projectDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.projectDescription)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UpdateProjectRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdateProjectRequest =
      zio.aws.iotsitewise.model.UpdateProjectRequest(
        projectId,
        projectName,
        projectDescription.map(value => value),
        clientToken.map(value => value)
      )
    def projectId: ID
    def projectName: Name
    def projectDescription: Option[Description]
    def clientToken: Option[ClientToken]
    def getProjectId: ZIO[Any, Nothing, ID] = ZIO.succeed(projectId)
    def getProjectName: ZIO[Any, Nothing, Name] = ZIO.succeed(projectName)
    def getProjectDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("projectDescription", projectDescription)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest
  ) extends zio.aws.iotsitewise.model.UpdateProjectRequest.ReadOnly {
    override val projectId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.projectId())
    override val projectName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.projectName())
    override val projectDescription: Option[Description] = scala
      .Option(impl.projectDescription())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateProjectRequest
  ): zio.aws.iotsitewise.model.UpdateProjectRequest.ReadOnly = new Wrapper(impl)
}
