package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, PropertyAlias, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAssetPropertyRequest(
    assetId: ID,
    propertyId: ID,
    propertyAlias: Option[PropertyAlias] = None,
    propertyNotificationState: Option[
      zio.aws.iotsitewise.model.PropertyNotificationState
    ] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest = {
    import UpdateAssetPropertyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .propertyId(ID.unwrap(propertyId): java.lang.String)
      .optionallyWith(
        propertyAlias.map(value =>
          PropertyAlias.unwrap(value): java.lang.String
        )
      )(_.propertyAlias)
      .optionallyWith(propertyNotificationState.map(value => value.unwrap))(
        _.propertyNotificationState
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.UpdateAssetPropertyRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdateAssetPropertyRequest.wrap(buildAwsValue())
}
object UpdateAssetPropertyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdateAssetPropertyRequest =
      zio.aws.iotsitewise.model.UpdateAssetPropertyRequest(
        assetId,
        propertyId,
        propertyAlias.map(value => value),
        propertyNotificationState.map(value => value),
        clientToken.map(value => value)
      )
    def assetId: ID
    def propertyId: ID
    def propertyAlias: Option[PropertyAlias]
    def propertyNotificationState
        : Option[zio.aws.iotsitewise.model.PropertyNotificationState]
    def clientToken: Option[ClientToken]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getPropertyId: ZIO[Any, Nothing, ID] = ZIO.succeed(propertyId)
    def getPropertyAlias: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("propertyAlias", propertyAlias)
    def getPropertyNotificationState: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.PropertyNotificationState
    ] = AwsError.unwrapOptionField(
      "propertyNotificationState",
      propertyNotificationState
    )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest
  ) extends zio.aws.iotsitewise.model.UpdateAssetPropertyRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val propertyId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.propertyId())
    override val propertyAlias: Option[PropertyAlias] = scala
      .Option(impl.propertyAlias())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val propertyNotificationState
        : Option[zio.aws.iotsitewise.model.PropertyNotificationState] = scala
      .Option(impl.propertyNotificationState())
      .map(value =>
        zio.aws.iotsitewise.model.PropertyNotificationState.wrap(value)
      )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetPropertyRequest
  ): zio.aws.iotsitewise.model.UpdateAssetPropertyRequest.ReadOnly =
    new Wrapper(impl)
}
