package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricWindow(
    tumbling: Option[zio.aws.iotsitewise.model.TumblingWindow] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.MetricWindow = {
    import MetricWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.MetricWindow
      .builder()
      .optionallyWith(tumbling.map(value => value.buildAwsValue()))(_.tumbling)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.MetricWindow.ReadOnly =
    zio.aws.iotsitewise.model.MetricWindow.wrap(buildAwsValue())
}
object MetricWindow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.MetricWindow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.MetricWindow =
      zio.aws.iotsitewise.model
        .MetricWindow(tumbling.map(value => value.asEditable))
    def tumbling: Option[zio.aws.iotsitewise.model.TumblingWindow.ReadOnly]
    def getTumbling: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.TumblingWindow.ReadOnly
    ] = AwsError.unwrapOptionField("tumbling", tumbling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.MetricWindow
  ) extends zio.aws.iotsitewise.model.MetricWindow.ReadOnly {
    override val tumbling
        : Option[zio.aws.iotsitewise.model.TumblingWindow.ReadOnly] = scala
      .Option(impl.tumbling())
      .map(value => zio.aws.iotsitewise.model.TumblingWindow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.MetricWindow
  ): zio.aws.iotsitewise.model.MetricWindow.ReadOnly = new Wrapper(impl)
}
