package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListProjectsRequest(
    portalId: ID,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest = {
    import ListProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest
      .builder()
      .portalId(ID.unwrap(portalId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListProjectsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListProjectsRequest.wrap(buildAwsValue())
}
object ListProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListProjectsRequest =
      zio.aws.iotsitewise.model.ListProjectsRequest(
        portalId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def portalId: ID
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getPortalId: ZIO[Any, Nothing, ID] = ZIO.succeed(portalId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest
  ) extends zio.aws.iotsitewise.model.ListProjectsRequest.ReadOnly {
    override val portalId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.portalId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListProjectsRequest
  ): zio.aws.iotsitewise.model.ListProjectsRequest.ReadOnly = new Wrapper(impl)
}
