package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{NextToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListProjectAssetsResponse(
    assetIds: Iterable[ID],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse = {
    import ListProjectAssetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse
      .builder()
      .assetIds(assetIds.map { item =>
        ID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListProjectAssetsResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListProjectAssetsResponse.wrap(buildAwsValue())
}
object ListProjectAssetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListProjectAssetsResponse =
      zio.aws.iotsitewise.model
        .ListProjectAssetsResponse(assetIds, nextToken.map(value => value))
    def assetIds: List[ID]
    def nextToken: Option[NextToken]
    def getAssetIds: ZIO[Any, Nothing, List[ID]] = ZIO.succeed(assetIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse
  ) extends zio.aws.iotsitewise.model.ListProjectAssetsResponse.ReadOnly {
    override val assetIds: List[ID] = impl
      .assetIds()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.primitives.ID(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListProjectAssetsResponse
  ): zio.aws.iotsitewise.model.ListProjectAssetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
