package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssetRelationshipsRequest(
    assetId: ID,
    traversalType: zio.aws.iotsitewise.model.TraversalType,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest = {
    import ListAssetRelationshipsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .traversalType(traversalType.unwrap)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAssetRelationshipsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAssetRelationshipsRequest
      .wrap(buildAwsValue())
}
object ListAssetRelationshipsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssetRelationshipsRequest =
      zio.aws.iotsitewise.model.ListAssetRelationshipsRequest(
        assetId,
        traversalType,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assetId: ID
    def traversalType: zio.aws.iotsitewise.model.TraversalType
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getTraversalType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.TraversalType] =
      ZIO.succeed(traversalType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest
  ) extends zio.aws.iotsitewise.model.ListAssetRelationshipsRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val traversalType: zio.aws.iotsitewise.model.TraversalType =
      zio.aws.iotsitewise.model.TraversalType.wrap(impl.traversalType())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssetRelationshipsRequest
  ): zio.aws.iotsitewise.model.ListAssetRelationshipsRequest.ReadOnly =
    new Wrapper(impl)
}
