package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IAMUserIdentity(arn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.IAMUserIdentity = {
    import IAMUserIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.IAMUserIdentity
      .builder()
      .arn(ARN.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.IAMUserIdentity.ReadOnly =
    zio.aws.iotsitewise.model.IAMUserIdentity.wrap(buildAwsValue())
}
object IAMUserIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.IAMUserIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.IAMUserIdentity =
      zio.aws.iotsitewise.model.IAMUserIdentity(arn)
    def arn: ARN
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.IAMUserIdentity
  ) extends zio.aws.iotsitewise.model.IAMUserIdentity.ReadOnly {
    override val arn: ARN = zio.aws.iotsitewise.model.primitives.ARN(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.IAMUserIdentity
  ): zio.aws.iotsitewise.model.IAMUserIdentity.ReadOnly = new Wrapper(impl)
}
