package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Timestamp, Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GatewaySummary(
    gatewayId: ID,
    gatewayName: Name,
    gatewayPlatform: Option[zio.aws.iotsitewise.model.GatewayPlatform] = None,
    gatewayCapabilitySummaries: Option[
      Iterable[zio.aws.iotsitewise.model.GatewayCapabilitySummary]
    ] = None,
    creationDate: Timestamp,
    lastUpdateDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GatewaySummary = {
    import GatewaySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GatewaySummary
      .builder()
      .gatewayId(ID.unwrap(gatewayId): java.lang.String)
      .gatewayName(Name.unwrap(gatewayName): java.lang.String)
      .optionallyWith(gatewayPlatform.map(value => value.buildAwsValue()))(
        _.gatewayPlatform
      )
      .optionallyWith(
        gatewayCapabilitySummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gatewayCapabilitySummaries)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .lastUpdateDate(Timestamp.unwrap(lastUpdateDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.GatewaySummary.ReadOnly =
    zio.aws.iotsitewise.model.GatewaySummary.wrap(buildAwsValue())
}
object GatewaySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GatewaySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.GatewaySummary =
      zio.aws.iotsitewise.model.GatewaySummary(
        gatewayId,
        gatewayName,
        gatewayPlatform.map(value => value.asEditable),
        gatewayCapabilitySummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationDate,
        lastUpdateDate
      )
    def gatewayId: ID
    def gatewayName: Name
    def gatewayPlatform
        : Option[zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly]
    def gatewayCapabilitySummaries: Option[
      List[zio.aws.iotsitewise.model.GatewayCapabilitySummary.ReadOnly]
    ]
    def creationDate: Timestamp
    def lastUpdateDate: Timestamp
    def getGatewayId: ZIO[Any, Nothing, ID] = ZIO.succeed(gatewayId)
    def getGatewayName: ZIO[Any, Nothing, Name] = ZIO.succeed(gatewayName)
    def getGatewayPlatform: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly
    ] = AwsError.unwrapOptionField("gatewayPlatform", gatewayPlatform)
    def getGatewayCapabilitySummaries: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.GatewayCapabilitySummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "gatewayCapabilitySummaries",
      gatewayCapabilitySummaries
    )
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GatewaySummary
  ) extends zio.aws.iotsitewise.model.GatewaySummary.ReadOnly {
    override val gatewayId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.gatewayId())
    override val gatewayName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.gatewayName())
    override val gatewayPlatform
        : Option[zio.aws.iotsitewise.model.GatewayPlatform.ReadOnly] = scala
      .Option(impl.gatewayPlatform())
      .map(value => zio.aws.iotsitewise.model.GatewayPlatform.wrap(value))
    override val gatewayCapabilitySummaries: Option[
      List[zio.aws.iotsitewise.model.GatewayCapabilitySummary.ReadOnly]
    ] = scala
      .Option(impl.gatewayCapabilitySummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.GatewayCapabilitySummary.wrap(item)
        }.toList
      )
    override val creationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.creationDate())
    override val lastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.lastUpdateDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GatewaySummary
  ): zio.aws.iotsitewise.model.GatewaySummary.ReadOnly = new Wrapper(impl)
}
