package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssetPropertyValue(
    value: zio.aws.iotsitewise.model.Variant,
    timestamp: zio.aws.iotsitewise.model.TimeInNanos,
    quality: Option[zio.aws.iotsitewise.model.Quality] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue = {
    import AssetPropertyValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue
      .builder()
      .value(value.buildAwsValue())
      .timestamp(timestamp.buildAwsValue())
      .optionallyWith(quality.map(value => value.unwrap))(_.quality)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly =
    zio.aws.iotsitewise.model.AssetPropertyValue.wrap(buildAwsValue())
}
object AssetPropertyValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetPropertyValue =
      zio.aws.iotsitewise.model.AssetPropertyValue(
        value.asEditable,
        timestamp.asEditable,
        quality.map(value => value)
      )
    def value: zio.aws.iotsitewise.model.Variant.ReadOnly
    def timestamp: zio.aws.iotsitewise.model.TimeInNanos.ReadOnly
    def quality: Option[zio.aws.iotsitewise.model.Quality]
    def getValue
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.Variant.ReadOnly] =
      ZIO.succeed(value)
    def getTimestamp
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.TimeInNanos.ReadOnly] =
      ZIO.succeed(timestamp)
    def getQuality: ZIO[Any, AwsError, zio.aws.iotsitewise.model.Quality] =
      AwsError.unwrapOptionField("quality", quality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue
  ) extends zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly {
    override val value: zio.aws.iotsitewise.model.Variant.ReadOnly =
      zio.aws.iotsitewise.model.Variant.wrap(impl.value())
    override val timestamp: zio.aws.iotsitewise.model.TimeInNanos.ReadOnly =
      zio.aws.iotsitewise.model.TimeInNanos.wrap(impl.timestamp())
    override val quality: Option[zio.aws.iotsitewise.model.Quality] = scala
      .Option(impl.quality())
      .map(value => zio.aws.iotsitewise.model.Quality.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetPropertyValue
  ): zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly = new Wrapper(impl)
}
