package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ID
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssetHierarchyInfo(
    parentAssetId: Option[ID] = None,
    childAssetId: Option[ID] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo = {
    import AssetHierarchyInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo
      .builder()
      .optionallyWith(
        parentAssetId.map(value => ID.unwrap(value): java.lang.String)
      )(_.parentAssetId)
      .optionallyWith(
        childAssetId.map(value => ID.unwrap(value): java.lang.String)
      )(_.childAssetId)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetHierarchyInfo.ReadOnly =
    zio.aws.iotsitewise.model.AssetHierarchyInfo.wrap(buildAwsValue())
}
object AssetHierarchyInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetHierarchyInfo =
      zio.aws.iotsitewise.model.AssetHierarchyInfo(
        parentAssetId.map(value => value),
        childAssetId.map(value => value)
      )
    def parentAssetId: Option[ID]
    def childAssetId: Option[ID]
    def getParentAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("parentAssetId", parentAssetId)
    def getChildAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("childAssetId", childAssetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo
  ) extends zio.aws.iotsitewise.model.AssetHierarchyInfo.ReadOnly {
    override val parentAssetId: Option[ID] = scala
      .Option(impl.parentAssetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val childAssetId: Option[ID] = scala
      .Option(impl.childAssetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetHierarchyInfo
  ): zio.aws.iotsitewise.model.AssetHierarchyInfo.ReadOnly = new Wrapper(impl)
}
