package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssetHierarchy(id: Option[ID] = None, name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy = {
    import AssetHierarchy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetHierarchy.ReadOnly =
    zio.aws.iotsitewise.model.AssetHierarchy.wrap(buildAwsValue())
}
object AssetHierarchy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetHierarchy =
      zio.aws.iotsitewise.model.AssetHierarchy(id.map(value => value), name)
    def id: Option[ID]
    def name: Name
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy
  ) extends zio.aws.iotsitewise.model.AssetHierarchy.ReadOnly {
    override val id: Option[ID] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetHierarchy
  ): zio.aws.iotsitewise.model.AssetHierarchy.ReadOnly = new Wrapper(impl)
}
