package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.Macro
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VariableValue(
    propertyId: Macro,
    hierarchyId: Option[Macro] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.VariableValue = {
    import VariableValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.VariableValue
      .builder()
      .propertyId(Macro.unwrap(propertyId): java.lang.String)
      .optionallyWith(
        hierarchyId.map(value => Macro.unwrap(value): java.lang.String)
      )(_.hierarchyId)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.VariableValue.ReadOnly =
    zio.aws.iotsitewise.model.VariableValue.wrap(buildAwsValue())
}
object VariableValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.VariableValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.VariableValue =
      zio.aws.iotsitewise.model
        .VariableValue(propertyId, hierarchyId.map(value => value))
    def propertyId: Macro
    def hierarchyId: Option[Macro]
    def getPropertyId: ZIO[Any, Nothing, Macro] = ZIO.succeed(propertyId)
    def getHierarchyId: ZIO[Any, AwsError, Macro] =
      AwsError.unwrapOptionField("hierarchyId", hierarchyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.VariableValue
  ) extends zio.aws.iotsitewise.model.VariableValue.ReadOnly {
    override val propertyId: Macro =
      zio.aws.iotsitewise.model.primitives.Macro(impl.propertyId())
    override val hierarchyId: Option[Macro] = scala
      .Option(impl.hierarchyId())
      .map(value => zio.aws.iotsitewise.model.primitives.Macro(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.VariableValue
  ): zio.aws.iotsitewise.model.VariableValue.ReadOnly = new Wrapper(impl)
}
